/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.common;

import com.ibm.hsc.auiml.databeans.common.PIVirtualSlotBaseDataBean;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIVirtualSlotDataBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import org.snia.wbem.cim.UnsignedInt16;

public abstract class PIVirtualClientServerBaseDataBean
extends PIVirtualSlotBaseDataBean {
    protected static final String ANY_STRING = "";
    protected static final UnsignedInt16 ANY_VALUE = new UnsignedInt16(65535);
    protected static final int SERVER_SELECTION_HMC = 1;
    protected static final int SERVER_SELECTION_ANY = 2;
    protected static final int SERVER_SELECTION_ONLY = 3;
    protected static final String INVALID_REMOTE_SLOT_NUMBER = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "INVALID_REMOTE_SLOT_NUMBER");
    protected static final String REMOTE_PARTITION_AND_SLOT_MUST_BE_SPECIFIED = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "REMOTE_PARTITION_AND_SLOT_MUST_BE_SPECIFIED");
    protected PICECDataBean m_cecCimBean;
    protected Map m_lparIDsToNames;
    protected Map m_lparIDsToDisplayNames;
    protected Map m_lparNamesToIDs;
    protected Map m_lparDisplayNamesToIDs;
    protected int m_deviceAttributes;
    protected int m_serverSelection;
    protected boolean m_supportsHMCConnection;
    protected UnsignedInt16 m_remotePartition;
    protected ValueDescriptor[] m_vdRemotePartition;
    protected UnsignedInt16 m_remoteSlot;
    protected ValueDescriptor[] m_vdRemoteSlot;
    protected String m_clientButtonName = "*****..*****";
    protected String m_serverButtonName = "*****..*****";
    protected String m_hmcConnectionButtonName = "*****..*****";
    protected String m_anyConnectionButtonName = "*****..*****";
    protected String m_onlyConnectionButtonName = "*****..*****";

    protected PIVirtualClientServerBaseDataBean(PIVirtualSlotDataBean pIVirtualSlotDataBean, PICECDataBean pICECDataBean, Map map, SortedSet sortedSet) {
        super(pIVirtualSlotDataBean, sortedSet);
        Object object;
        this.m_cecCimBean = pICECDataBean;
        this.m_lparIDsToNames = map;
        this.m_lparNamesToIDs = new HashMap();
        this.m_lparIDsToDisplayNames = new HashMap();
        this.m_lparDisplayNamesToIDs = new HashMap();
        this.m_supportsHMCConnection = false;
        this.m_remotePartition = ANY_VALUE;
        this.m_remoteSlot = ANY_VALUE;
        int n = this.m_lparIDsToNames.size();
        this.m_vdRemotePartition = new ValueDescriptor[n + 1];
        Object[] objectArray = new String[n + 1];
        objectArray[0] = ANY_STRING;
        Iterator iterator = this.m_lparIDsToNames.entrySet().iterator();
        int n2 = 1;
        while (iterator.hasNext()) {
            object = iterator.next();
            String string = (String)object.getKey();
            String string2 = (String)object.getValue();
            this.m_lparNamesToIDs.put(string2, string);
            String string3 = this.getPartitionDisplayName(string2, string);
            this.m_lparIDsToDisplayNames.put(string, string3);
            this.m_lparDisplayNamesToIDs.put(string3, string);
            objectArray[n2] = string3;
            ++n2;
        }
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        this.m_vdRemoteSlot = new ValueDescriptor[1];
        Object object2 = null;
        object = null;
        if (this.m_lparIDsToNames.size() > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                object2 = objectArray[i];
                object = (String)this.m_lparDisplayNamesToIDs.get(object2);
                this.m_vdRemotePartition[i] = object != null ? new ValueDescriptor("ID_" + (String)object, (String)object2) : new ValueDescriptor("ID_" + ANY_VALUE.toString(), ANY_STRING);
            }
        }
        this.m_vdRemoteSlot[0] = new ValueDescriptor("SLOT_" + ANY_VALUE.toString(), ANY_STRING);
    }

    public void setTypeGroupSelection(String[] stringArray) throws IllegalUserDataException {
        if (stringArray != null && stringArray.length == 1) {
            if (stringArray[0].endsWith(this.m_clientButtonName)) {
                this.m_deviceAttributes = 0;
            } else if (stringArray[0].endsWith(this.m_serverButtonName)) {
                this.m_deviceAttributes = 1;
            } else {
                System.out.println("Unknown type: " + stringArray[0]);
            }
        }
    }

    public String[] getTypeGroupSelection() {
        System.out.println("getTypeGroupSelection()");
        String[] stringArray = null;
        switch (this.m_deviceAttributes) {
            case 0: {
                stringArray = new String[]{this.m_clientButtonName};
                break;
            }
            case 1: {
                stringArray = new String[]{this.m_serverButtonName};
            }
        }
        return stringArray;
    }

    public void setConnectionAuthorizationGroupSelection(String[] stringArray) throws IllegalUserDataException {
        System.out.println("setConnectionAuthorizationGroupSelection() - ");
        if (stringArray != null && stringArray.length == 1 && stringArray[0] != null) {
            if (stringArray[0].endsWith(this.m_hmcConnectionButtonName)) {
                this.m_supportsHMCConnection = true;
                this.m_remotePartition = ANY_VALUE;
                this.m_remoteSlot = ANY_VALUE;
                this.m_serverSelection = 1;
                System.out.println("setConnectionAuthorizationGroupSelection: HMC (" + stringArray[0] + ")");
            } else if (stringArray[0].endsWith(this.m_anyConnectionButtonName)) {
                this.m_supportsHMCConnection = false;
                this.m_remotePartition = ANY_VALUE;
                this.m_remoteSlot = ANY_VALUE;
                this.m_serverSelection = 2;
                System.out.println("setConnectionAuthorizationGroupSelection: Any (" + stringArray[0] + ")");
            } else if (stringArray[0].endsWith(this.m_onlyConnectionButtonName)) {
                this.m_supportsHMCConnection = false;
                this.m_serverSelection = 3;
                System.out.println("setConnectionAuthorizationGroupSelection: Only (" + stringArray[0] + ")");
            } else {
                System.out.println("Unknown type: " + stringArray[0]);
                this.m_serverSelection = 0;
            }
        } else if (stringArray == null) {
            System.out.println("Selected = null");
        } else if (stringArray.length != 1) {
            System.out.println("Selected.length != 1: " + stringArray.length);
        } else {
            System.out.println("Selected[0] = null");
        }
    }

    public String[] getConnectionAuthorizationGroupSelection() {
        System.out.println("getConnectionAuthorizationGroupSelection()");
        String[] stringArray = null;
        if (this.m_supportsHMCConnection) {
            stringArray = new String[]{this.m_hmcConnectionButtonName};
            System.out.println("getConnectionAuthorizationGroupSelection: HMC (" + this.m_hmcConnectionButtonName + ")");
        } else if (this.m_remotePartition.equals((Object)ANY_VALUE)) {
            stringArray = new String[]{this.m_anyConnectionButtonName};
            System.out.println("getConnectionAuthorizationGroupSelection: Any (" + this.m_anyConnectionButtonName + ")");
        } else {
            stringArray = new String[]{this.m_onlyConnectionButtonName};
            System.out.println("getConnectionAuthorizationGroupSelection: Only (" + this.m_onlyConnectionButtonName + ")");
        }
        return stringArray;
    }

    public ValueDescriptor[] getRemotePartitionList() {
        return this.m_vdRemotePartition;
    }

    public void setRemotePartition(String string) throws IllegalUserDataException {
        String string2 = null;
        string2 = (String)this.m_lparDisplayNamesToIDs.get(string);
        if (string2 != null) {
            this.m_remotePartition = new UnsignedInt16(string2);
        } else {
            string = string.trim();
            try {
                this.m_remotePartition = new UnsignedInt16(string);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = (String)this.m_lparNamesToIDs.get(string);
                this.m_remotePartition = string2 != null ? new UnsignedInt16(string2) : null;
            }
        }
        if (this.m_remotePartition == null || this.m_remotePartition.intValue() > this.m_cecCimBean.m_numberOfLPARSlots.intValue()) {
            throw new IllegalUserDataException(HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "INVALID_REMOTE_PARTITION_ID", "NLS_MESSAGE_NOT_FOUND", new String[]{this.m_cecCimBean.m_numberOfLPARSlots.toString()}));
        }
    }

    public String getRemotePartition() {
        if (ANY_VALUE.equals((Object)this.m_remotePartition)) {
            return ANY_STRING;
        }
        String string = this.m_remotePartition.toString();
        String string2 = (String)this.m_lparIDsToDisplayNames.get(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public ValueDescriptor[] getRemoteSlotList() {
        return this.m_vdRemoteSlot;
    }

    public void setRemoteSlot(String string) throws IllegalUserDataException {
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (n < 0 || n > 65534) {
                    throw new IllegalUserDataException(INVALID_REMOTE_SLOT_NUMBER);
                }
                this.m_remoteSlot = new UnsignedInt16(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalUserDataException(INVALID_REMOTE_SLOT_NUMBER);
            }
        } else {
            throw new IllegalUserDataException(INVALID_REMOTE_SLOT_NUMBER);
        }
    }

    public String getRemoteSlot() {
        if (ANY_VALUE.equals((Object)this.m_remoteSlot)) {
            return ANY_STRING;
        }
        return this.m_remoteSlot.toString();
    }

    public void load() {
        super.load();
    }

    public void verifyChanges() throws IllegalUserDataException {
        System.out.println("RemotePartition = " + this.m_remotePartition + ", RemoteSlot = " + this.m_remoteSlot);
        if (this.m_remotePartition == ANY_VALUE ^ this.m_remoteSlot == ANY_VALUE) {
            throw new IllegalUserDataException(REMOTE_PARTITION_AND_SLOT_MUST_BE_SPECIFIED);
        }
        if (this.m_deviceAttributes == 0 && (this.m_remotePartition == ANY_VALUE || this.m_remoteSlot == ANY_VALUE)) {
            throw new IllegalUserDataException(REMOTE_PARTITION_AND_SLOT_MUST_BE_SPECIFIED);
        }
        if (this.m_deviceAttributes == 1 && this.m_serverSelection == 3 && (this.m_remotePartition == ANY_VALUE || this.m_remoteSlot == ANY_VALUE)) {
            throw new IllegalUserDataException(REMOTE_PARTITION_AND_SLOT_MUST_BE_SPECIFIED);
        }
        super.verifyChanges();
    }

    public void save() {
        super.save();
    }

    public String getPartitionDisplayName(String string, String string2) {
        return string + " (" + string2 + ")";
    }
}

